varying vec3 I;
varying vec3  ViewVec;
uniform sampler3D volumeTexture;      //Texture containing gradient and density

uniform float normalCont;

uniform float boundCont, boundExp;    //Contribution of boundary enhancement calculated opacity
uniform float invMaxGrad;             //The inverse of the maximum gradient magnitude

uniform float silhCont, silhExp;      //Opacity contribution of silhouette function and

uniform float toneCont;               //Contribution of tone color
uniform vec3 warmCol, coolCol;        //Warm and cool tone colors

uniform vec3 toonCol;

uniform float distCont, distExp;      //Opacity contribution of silhouette function and

//switches
uniform int lighting, tone, boundary, silhoutte, toon, dist;

void main()
{
	//get the texture rgba data
	vec4 texValue = texture3D(volumeTexture, gl_TexCoord[0].stp);

	//if(texValue.a==0.0) discard;

	//evaluate the voxel gradient for current pos
	float stepsize	= 1.0/256.0;
  	vec4 normal;
    normal.x = (texture3D(volumeTexture, vec3(gl_TexCoord[0].s-stepsize, gl_TexCoord[0].t, gl_TexCoord[0].p)) - texture3D(volumeTexture, vec3(gl_TexCoord[0].s+stepsize, gl_TexCoord[0].t, gl_TexCoord[0].p))).x;
    normal.y = (texture3D(volumeTexture, vec3(gl_TexCoord[0].s, gl_TexCoord[0].t-stepsize, gl_TexCoord[0].p)) - texture3D(volumeTexture, vec3(gl_TexCoord[0].s, gl_TexCoord[0].t+stepsize, gl_TexCoord[0].p))).y;
    normal.z = (texture3D(volumeTexture, vec3(gl_TexCoord[0].s, gl_TexCoord[0].t, gl_TexCoord[0].p-stepsize)) - texture3D(volumeTexture, vec3(gl_TexCoord[0].s, gl_TexCoord[0].t, gl_TexCoord[0].p+stepsize))).z;
	float gradMag = length(normal);

	bool degenerate = length(texValue.rgb) < .1;
	if(!degenerate)
		normal.rgb = normalize(gl_NormalMatrix * normalize(normal.rgb));
	
	vec3 normal2 = vec3(normal);

	//need to try 2d texmap has Transfer function
	vec4 texColor = texValue;
    
	//We have to scale the gradient between -1 and 1
	normal.rgb = normal.rgb*2.0 - 1.0;

	//Calculate the angle between the viewer and the gradient in eye space
	//The viewer always looks down 0,0,-1 in eye space ViewVec
	float dotView = dot(vec3(0,0,-1), normal.rgb);
					
	//Create a vector where the final color will be stored
	vec4 finalColor = vec4(0.0,0.0,0.0,0.0);	

	finalColor = texColor;
    
	//Calculate the diffuse contribution of the light
	float dotLight = dot(normalize(vec3(-gl_LightSource[0].position)), normal.rgb);

	//do lighting
	if(lighting==1) finalColor.rgb *= vec3(gl_FrontLightProduct[0].ambient+(gl_FrontLightProduct[0].diffuse *dotLight));		

	//Create copy of dot product for tone shading
	float toneLight = dotLight;

	//Calculate the correct color according to the Gooch shading model.
	//toneLight ranges from -1 to 1
	if(tone==1)
		finalColor.rgb += toneCont*(((1.0+toneLight)*.5)*warmCol + (1.0-((1.0+toneLight)*.5))*coolCol);

	if(boundary==1)
		//finalColor.a  = 0.3 + boundCont*pow(gradMag, boundExp);
		finalColor.a += boundCont*pow(invMaxGrad*gradMag,boundExp);
	
	if(silhoutte==1)
	{
		if(!degenerate)			
			finalColor.a += silhCont*pow(1.0-abs(dotView),silhExp);
	}
	
	//If we want to do toon shading we...
	if(toon==1)
	{	
		//...create a set of 4 colors that go from bright
		//to the specified toon color
		vec3 col	= toonCol - vec3(1.0, 1.0, 1.0);
		vec4 color1 = vec4(toonCol - .75*col, finalColor.a);
		vec4 color2 = vec4(toonCol - .5*col, finalColor.a);
		vec4 color3 = vec4(toonCol - .25*col, finalColor.a);
		vec4 color4 = vec4(toonCol, finalColor.a);
	
		//and then assign different ranges of the diffuse
		//coefficient to one of the 4 colors
		if (dotLight > 0.75)
			finalColor = color1;
		else if (dotLight > 0.25)
			finalColor = color2;
		else if (dotLight > 0.125)
			finalColor = color3;
		else
			finalColor = color4;	
	}

	//   float opac = dot(vec3(normal2), normalize(-I));
//	opac = abs(opac);
  //  opac = 1.0-pow(opac, 5.0);
    
  //  gl_FragColor =  opac * texColor;
  //  gl_FragColor.a = texColor.a;

	//Apply the final color the fragment.								
	gl_FragColor = finalColor;	
}